/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)03       1.7  src/avs/fs/mmfs/ts/kernext/ibm-linux/cxiVFSStats-plat.h, mmfs, avs_remp, rempt1d1 9/21/01 02:08:35 */
#ifndef _h_cxiVFSStats_plat
#define _h_cxiVFSStats_plat

/*
 * Gather statistics for VFS operations:
 *
 * Usage:
 *  - Placing an instance of the VFS_STAT_START macro at the begining
 *    of a function and VFS_STAT_STOP macro at the end of a function
 *    will keep a count of how many times the function is called as well
 *    as the total amount of time spent in the function (elapsed time
 *    between entering and leaving the function).
 *  - Placing an instance of the VFS_INC macro inside a function will
 *    update a call count, but not keep any time statistics.
 *  - Use the command "mmfsadm vfsstats ..." to control and display
 *    vfs statistics:
 *       mmfsadm vfsstats enable    - turn on statistics gathering
 *       mmfsadm vfsstats disable   - turn off statistics gathering
 *       mmfsadm vfsstats reset     - reset all statistics counters
 *       mmfsadm vfsstats show      - display statistics
 *
 * $Id: cxiVFSStats-plat.h,v 1.7 2001/09/20 21:48:41 wyllie Exp $
 *
 * $Log: cxiVFSStats-plat.h,v $
 * Revision 1.7  2001/09/20 21:48:41  wyllie
 * Move enum and table for vfsstats from platform files to main file, since
 * they are the same.
 *
 * Revision 1.6  2001/09/18 06:10:12  schmuck
 * Add some conditional code to help trace context switches.
 *
 * Revision 1.5  2001/09/13 18:36:08  eshel
 * Performance improvement to skip multiple sync calls for the same file.
 *
 * Revision 1.4  2001/04/05 13:31:35  gjertsen
 * Make vfs stat stuff C friendly.
 *
 * Revision 1.3  2001/01/24 00:19:39  schmuck
 * Tweak VFS_STATS statistics.
 *
 * Revision 1.2  2000/12/15 13:57:22  gjertsen
 * Clean up documentation.
 *
 * Revision 1.1  2000/11/02 19:47:01  gjertsen
 * Linux code split.
 * 
 *
 */

#ifdef KCSTRACE
#ifdef __cplusplus
extern "C" {
#endif
void cxiKcsTraceInfo(int index, int value);
#ifdef __cplusplus
}
#endif
#endif

#endif // _h_cxiVFSStats_plat
